(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5326,        198]*)
(*NotebookOutlinePosition[      6168,        225]*)
(*  CellTagsIndexPosition[      6124,        221]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 4.1 \( \(.1\)\(.\)\)\ *) \[IndentingNewLine]\(n = 
        8;\)\), "\n", 
    \(\(s[j_] := \ Cos[j\ \[Pi]/n];\)\), "\n", 
    \(c = Table[s[j], \ {j, \ 0, \ n}] // N\)}], "Input"],

Cell[BoxData[
    \({1.`, 0.923879532511286782`, 0.707106781186547461`, 
      0.382683432365089792`, 0, \(-0.382683432365089792`\), 
      \(-0.707106781186547461`\), \(-0.923879532511286782`\), \(-1.`\)}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(x[m_] := \(-1\) + 2\ m/n; \nb = Table[x[m], \ {m, 0, n}]\)], "Input"],

Cell[BoxData[
    \({\(-1\), \(-\(3\/4\)\), \(-\(1\/2\)\), \(-\(1\/4\)\), 0, 1\/4, 1\/2, 
      3\/4, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[x_, s_] := \ 1/\((1 + \((x - s)\)^2)\); \n
    g[b[\([n]\)], c[\([n]\)]]\)], "Input"],

Cell[BoxData[
    \(0.263028270988286205`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(a[m_] := \ 
      \((2/n)\)*
        \((0.5*\((
                g[b[\([m]\)], c[\([1]\)]]*ChebyshevT[m, c[\([1]\)]] + 
                  g[b[\([m]\)], c[\([n]\)]]*ChebyshevT[m, c[\([n]\)]])\) + \ 
            NSum[g[b[\([m]\)], c[\([j]\)]]*ChebyshevT[m, c[\([j]\)]], 
              \ {j, 1, n - 1}])\); \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a[0]\)], "Input"],

Cell[BoxData[
    \({1.`, 0.923879532511286782`, 0.707106781186547461`, 
        0.382683432365089792`, 0, \(-0.382683432365089792`\), 
        \(-0.707106781186547461`\), \(-0.923879532511286782`\), \(-1.`\)}[0]
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[b[\([1]\)], c[\([1]\)]]*ChebyshevT[0, c[\([1]\)]]\)], "Input"],

Cell[BoxData[
    \(0.2`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ChebyshevT[0, c[\([1]\)]]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[b[\([9]\)], c[\([9]\)]]*ChebyshevT[0, c[\([9]\)]]\)], "Input"],

Cell[BoxData[
    \(0.2`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[b[\([9]\)], c[\([9]\)]]\)], "Input"],

Cell[BoxData[
    \(0.2`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ChebyshevT[0, c[\([9]\)]]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef[0] = 
      0.25*\((0.5*
              \((g[b[\([1]\)], c[\([1]\)]]*ChebyshevT[0, c[\([1]\)]] + 
                  g[0, c[\([9]\)]]*ChebyshevT[0, c[\([9]\)]])\) + \n\t\t\t\t
            Sum[g[0, c[\([j]\)]]*ChebyshevT[0, c[\([j]\)]], \ {j, 2, 8}])
          \)\)], "Input"],

Cell[BoxData[
    \(1.37671568627450957`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(a[m_] := 
      0.25*\((0.5*
              \((g[m, c[\([1]\)]]*ChebyshevT[m, c[\([1]\)]] + 
                  g[m, c[\([9]\)]]*ChebyshevT[m, c[\([9]\)]])\) + \n\t\t\t\t
            Sum[g[m, c[\([j]\)]]*ChebyshevT[m, c[\([j]\)]], \ {j, 2, 8}])\); 
    \)\)], "Input"],

Cell[BoxData[
    \(\(w[j_] := 
      \((4/8)\)*
        Sum[\((Cos[2\ j\ m\ \[Pi]/8])\)/\((1 - 4\ m^2)\), \ {m, 0, 4}]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[w[j], \ {j, 1, 7}] // N\)], "Input"],

Cell[BoxData[
    \({0.400186903184272058`, 0.525396825396825395`, 0.615686112688743758`, 
      0.63968253968253963`, 0.615686112688743758`, 0.525396825396825395`, 
      0.400186903184272058`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(w[0] = \(w[8] = 1/\((8^2 - 1)\) // N\)\)], "Input"],

Cell[BoxData[
    \(0.0158730158730158716`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{5, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 214, 4, 75, "Input"],
Cell[1956, 57, 222, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2215, 66, 89, 1, 43, "Input"],
Cell[2307, 69, 118, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2462, 76, 107, 2, 43, "Input"],
Cell[2572, 80, 55, 1, 26, "Output"]
}, Open  ]],
Cell[2642, 84, 340, 7, 107, "Input"],

Cell[CellGroupData[{
Cell[3007, 95, 37, 1, 27, "Input"],
Cell[3047, 98, 233, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3317, 107, 84, 1, 27, "Input"],
Cell[3404, 110, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3479, 116, 58, 1, 27, "Input"],
Cell[3540, 119, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3612, 125, 84, 1, 27, "Input"],
Cell[3699, 128, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3774, 134, 58, 1, 27, "Input"],
Cell[3835, 137, 38, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3910, 143, 58, 1, 27, "Input"],
Cell[3971, 146, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4043, 152, 298, 6, 75, "Input"],
Cell[4344, 160, 54, 1, 26, "Output"]
}, Open  ]],
Cell[4413, 164, 288, 6, 59, "Input"],
Cell[4704, 172, 141, 4, 43, "Input"],

Cell[CellGroupData[{
Cell[4870, 180, 62, 1, 27, "Input"],
Cell[4935, 183, 208, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5180, 191, 71, 1, 27, "Input"],
Cell[5254, 194, 56, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

